/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Connector {
    private String connectorId;
    private boolean isOnPremSaws;
    private String websocketConnId;
    private String sawsHostname;
    private String sawsPort;

    public Connector(String connectorId, boolean isOnPremSaws, String websocketConnId, String sawsHostname, String sawsPort) {
        this.connectorId = connectorId;
        this.isOnPremSaws = isOnPremSaws;
        this.websocketConnId = websocketConnId;
        this.sawsHostname = sawsHostname;
        this.sawsPort = sawsPort;
    }

    public Connector(JSONObject connectorDetails) {
        this.connectorId = String.valueOf(connectorDetails.get((Object)"connector_id"));
        this.isOnPremSaws = Boolean.parseBoolean(String.valueOf(connectorDetails.get((Object)"is_on_prem_saws")));
        this.websocketConnId = String.valueOf(connectorDetails.get((Object)"websocket_conn_id"));
        this.sawsHostname = String.valueOf(connectorDetails.get((Object)"saws_hostname"));
        this.sawsPort = String.valueOf(connectorDetails.get((Object)"saws_port"));
    }

    public String getSawsHostname() {
        return this.sawsHostname;
    }

    public void setSawsHostname(String sawsHostname) {
        this.sawsHostname = sawsHostname;
    }

    public String getSawsPort() {
        return this.sawsPort;
    }

    public void setSawsPort(String sawsPort) {
        this.sawsPort = sawsPort;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(String connectorId) {
        this.connectorId = connectorId;
    }

    public boolean isCloudSaws() {
        return this.isOnPremSaws;
    }

    public void setCloudSaws(boolean cloudSaws) {
        this.isOnPremSaws = cloudSaws;
    }

    public String getWebsocketConnId() {
        return this.websocketConnId;
    }

    public void setWebsocketConnId(String websocketConnId) {
        this.websocketConnId = websocketConnId;
    }

    public static List<Connector> getConnectorsFromJson(JSONArray connectorsJson) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Object connectorObj : connectorsJson) {
            JSONObject connectorDetails = (JSONObject)connectorObj;
            String connectorId = String.valueOf(connectorDetails.get((Object)"connector_id"));
            String sawsHostname = String.valueOf(connectorDetails.get((Object)"saws_hostname"));
            String sawsPort = String.valueOf(connectorDetails.get((Object)"saws_port"));
            Boolean isOnPremSaws = Boolean.parseBoolean(String.valueOf(connectorDetails.get((Object)"is_on_prem_saws")));
            String websocketConnId = String.valueOf(connectorDetails.get((Object)"websocket_conn_id"));
            Connector connector = new Connector(connectorId, isOnPremSaws, websocketConnId, sawsHostname, sawsPort);
            connectors.add(connector);
        }
        return connectors;
    }

    public static Connector getConnectorById(String connectorId, List<Connector> connectors) {
        Connector requiredConnector = null;
        for (Connector connector : connectors) {
            if (!connector.getConnectorId().equalsIgnoreCase(connectorId)) continue;
            requiredConnector = connector;
            break;
        }
        return requiredConnector;
    }

    public JSONObject toJSON() {
        JSONObject connectorJson = new JSONObject();
        connectorJson.put((Object)"connector_id", (Object)this.connectorId);
        connectorJson.put((Object)"is_on_prem_saws", (Object)this.isOnPremSaws);
        connectorJson.put((Object)"websocket_conn_id", (Object)this.websocketConnId);
        connectorJson.put((Object)"saws_hostname", (Object)this.sawsHostname);
        connectorJson.put((Object)"saws_port", (Object)this.sawsPort);
        return connectorJson;
    }
}

