/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.rule.ColumnProfileOutput;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ColumnDetail {
    private String colId;
    private String srcId;
    private Integer colSeq;
    private String colName;
    private ColumnProfileOutput prfOutput;
    private String prfStatus;
    private String prfErrorMsg;
    private String colDataType;
    private Boolean isColumnMasked;

    public ColumnDetail(String colId, String srcId, Integer colSeq, String colName, ColumnProfileOutput prfOutput, String prfStatus, String prfErrorMsg, String colDataType, Boolean isColumnMasked) {
        this.colId = colId;
        this.srcId = srcId;
        this.colSeq = colSeq;
        this.colName = colName;
        this.prfOutput = prfOutput;
        this.prfStatus = prfStatus;
        this.prfErrorMsg = prfErrorMsg;
        this.colDataType = colDataType;
        this.isColumnMasked = isColumnMasked;
    }

    public ColumnDetail(JSONObject columnJson) {
        this.colId = columnJson.containsKey((Object)"col_id") ? (String)columnJson.get((Object)"col_id") : null;
        this.srcId = columnJson.containsKey((Object)"src_id") ? (String)columnJson.get((Object)"src_id") : null;
        this.colSeq = columnJson.containsKey((Object)"col_seq") ? Integer.valueOf(((Long)columnJson.get((Object)"col_seq")).intValue()) : null;
        this.colName = columnJson.containsKey((Object)"col_name") ? (String)columnJson.get((Object)"col_name") : null;
        this.isColumnMasked = columnJson.containsKey((Object)"is_col_masked") ? (Boolean)columnJson.get((Object)"is_col_masked") : false;
        this.prfOutput = columnJson.containsKey((Object)"prf_output") ? new ColumnProfileOutput((JSONObject)columnJson.get((Object)"prf_output")) : null;
        this.prfStatus = columnJson.containsKey((Object)"prf_status") ? (String)columnJson.get((Object)"prf_status") : null;
        this.prfErrorMsg = columnJson.containsKey((Object)"prf_error_msg") ? (String)columnJson.get((Object)"prf_error_msg") : null;
        this.colDataType = columnJson.containsKey((Object)"col_data_type") ? (String)columnJson.get((Object)"col_data_type") : null;
    }

    public static List<ColumnDetail> getColumnDetailsFromJsonArray(JSONArray colDetailsJsonArray) {
        ArrayList<ColumnDetail> columnDetails = new ArrayList<ColumnDetail>();
        if (colDetailsJsonArray != null) {
            for (Object obj : colDetailsJsonArray) {
                JSONObject colDetailJson = (JSONObject)obj;
                String colId = String.valueOf(colDetailJson.getOrDefault((Object)"col_id", null));
                String srcId = String.valueOf(colDetailJson.getOrDefault((Object)"src_id", null));
                Integer colSeq = colDetailJson.get((Object)"col_seq") instanceof Long ? Integer.valueOf(((Long)colDetailJson.get((Object)"col_seq")).intValue()) : null;
                String colName = String.valueOf(colDetailJson.getOrDefault((Object)"col_name", null));
                boolean isColumnMasked = Boolean.valueOf(String.valueOf(colDetailJson.getOrDefault((Object)"is_col_masked", null)));
                ColumnProfileOutput prfOutput = colDetailJson.get((Object)"prf_output") != null ? new ColumnProfileOutput((JSONObject)colDetailJson.get((Object)"prf_output")) : null;
                String prfStatus = String.valueOf(colDetailJson.getOrDefault((Object)"prf_status", null));
                String prfErrorMsg = String.valueOf(colDetailJson.getOrDefault((Object)"prf_error_msg", null));
                String colDataType = String.valueOf(colDetailJson.getOrDefault((Object)"col_data_type", null));
                ColumnDetail columnDetail = new ColumnDetail(colId, srcId, colSeq, colName, prfOutput, prfStatus, prfErrorMsg, colDataType, isColumnMasked);
                columnDetails.add(columnDetail);
            }
        }
        return columnDetails;
    }

    public static ColumnDetail findColumnById(String colId, List<ColumnDetail> columnDetails) {
        ColumnDetail requiredColumnDetails = null;
        for (ColumnDetail columnDetail : columnDetails) {
            if (!colId.equals(columnDetail.getColId())) continue;
            requiredColumnDetails = columnDetail;
        }
        return requiredColumnDetails;
    }

    public JSONObject toJSON() {
        JSONObject columnJson = new JSONObject();
        columnJson.put((Object)"col_id", (Object)this.colId);
        columnJson.put((Object)"src_id", (Object)this.srcId);
        columnJson.put((Object)"col_seq", (Object)this.colSeq);
        columnJson.put((Object)"col_name", (Object)this.colName);
        columnJson.put((Object)"is_col_masked", (Object)this.isColumnMasked);
        columnJson.put((Object)"prf_output", this.prfOutput != null ? this.prfOutput.toJSON() : null);
        columnJson.put((Object)"prf_status", (Object)this.prfStatus);
        columnJson.put((Object)"prf_error_msg", (Object)this.prfErrorMsg);
        columnJson.put((Object)"col_data_type", (Object)this.colDataType);
        return columnJson;
    }

    public String getColId() {
        return this.colId;
    }

    public void setColId(String colId) {
        this.colId = colId;
    }

    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public Integer getColSeq() {
        return this.colSeq;
    }

    public void setColSeq(Integer colSeq) {
        this.colSeq = colSeq;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public Boolean getIsColumnMasked() {
        return this.isColumnMasked;
    }

    public void setIsColumnMasked(Boolean isColumnMasked) {
        this.isColumnMasked = isColumnMasked;
    }

    public ColumnProfileOutput getPrfOutput() {
        return this.prfOutput;
    }

    public void setPrfOutput(ColumnProfileOutput prfOutput) {
        this.prfOutput = prfOutput;
    }

    public String getPrfStatus() {
        return this.prfStatus;
    }

    public void setPrfStatus(String prfStatus) {
        this.prfStatus = prfStatus;
    }

    public String getPrfErrorMsg() {
        return this.prfErrorMsg;
    }

    public void setPrfErrorMsg(String prfErrorMsg) {
        this.prfErrorMsg = prfErrorMsg;
    }

    public String getColDataType() {
        return this.colDataType;
    }

    public void setColDataType(String colDataType) {
        this.colDataType = colDataType;
    }
}

