/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.rule.Connector;
import com.dvsum.rule.Node;
import com.dvsum.rule.NodeExecutionMetadata;
import com.dvsum.rule.Source;
import com.dvsum.rule.SqlQuery;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.websocket.ConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BaseRule {
    private static final CustomLogger logger = CustomLogger.getLogger(BaseRule.class);
    protected ExecutorService executorService;
    protected DataSourceFactory dataSourceFactory;
    protected Node node;
    protected List<Source> sources;
    protected LogFormat logFormat;
    protected String baseFilePath;
    protected JSONObject s3PreSignedURLInfo;
    protected String executionId;
    Connector connector;
    protected List<Future<JSONObject>> futureResults;
    protected JSONArray queryResultsJsonArray;
    protected String websocketMessageS3FilePath;

    public BaseRule(ExecutorService executorService, Node node, List<Source> sources, Connector connector, String executionId, JSONObject s3PreSignedURLInfo, LogFormat logFormat) {
        this.executorService = executorService;
        this.dataSourceFactory = new DataSourceFactory();
        this.node = node;
        this.executionId = executionId;
        this.baseFilePath = "./dq_analysis/" + this.executionId + "/";
        this.sources = sources;
        this.s3PreSignedURLInfo = s3PreSignedURLInfo;
        this.connector = connector;
        this.logFormat = logFormat;
        this.futureResults = new ArrayList<Future<JSONObject>>();
        this.queryResultsJsonArray = new JSONArray();
        this.websocketMessageS3FilePath = null;
    }

    public void executeQueries() {
        try {
            for (SqlQuery ruleQuery : this.node.getSqlQueries()) {
                logger.info(this.logFormat.getFormattedLog(), "Executing query id : ", ruleQuery.getQryId());
                Future<JSONObject> queryResultFuture = this.submitQueryToExecute(ruleQuery);
                this.futureResults.add(queryResultFuture);
            }
            this.getQueryResults();
            this.processQueryResults();
            this.dumpWebsocketMessageToS3(this.node.toJSON(), String.valueOf(this.node.getRuleId()) + "_output_metadata.json");
            this.sendMessageToWebsocket();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(this.logFormat.getFormattedLog(), "Error ", e);
        }
    }

    public Future<JSONObject> submitQueryToExecute(SqlQuery ruleQuery) {
        Future queryResultsFuture = null;
        try {
            Source source = Source.findSourceById(ruleQuery.getSrcId(), this.sources);
            QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, source.getConnConfigForQueryExecutor(ruleQuery.getQryId(), ruleQuery.getQryType(), ruleQuery.getSqlText()), false, this.logFormat);
            queryResultsFuture = this.executorService.submit(queryExecutor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryResultsFuture;
    }

    protected void getQueryResults() {
        if (this.futureResults == null || this.futureResults.size() <= 0) {
            return;
        }
        for (Future<JSONObject> queryResults : this.futureResults) {
            try {
                if (queryResults.get() == null || queryResults.get().isEmpty()) continue;
                this.queryResultsJsonArray.add((Object)queryResults.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void processQueryResults() {
        for (Object queryResultObj : this.queryResultsJsonArray) {
            JSONObject queryResult = (JSONObject)queryResultObj;
            SqlQuery ruleQuery = SqlQuery.getSqlQueryByQueryId(String.valueOf(queryResult.get((Object)"queryId")), this.node.getSqlQueries());
            if ("AIS".equals(ruleQuery.getQryType()) && ruleQuery.getQryOutput() != null) {
                queryResult = this.getResultsAsItIs(ruleQuery.getQryOutput());
            }
            logger.info(this.logFormat.getFormattedLog(), "Processing query results for query id : ", ruleQuery.getQryId());
            this.queryOutputHandler(queryResult, ruleQuery);
            logger.info(this.logFormat.getFormattedLog(), "Execution completed for Query Id : ", ruleQuery.getQryId());
        }
    }

    private JSONObject getResultsAsItIs(JSONArray jsonObjectArray) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"results", (Object)jsonObjectArray);
        JSONObject tempDebug = new JSONObject();
        tempDebug.put((Object)"runJson", (Object)jsonObject);
        tempDebug.put((Object)"runStatus", (Object)"0");
        return tempDebug;
    }

    public SqlQuery queryOutputHandler(JSONObject queryResult, SqlQuery ruleQuery) {
        String runStatus = QueryExecutor.getRunStatus(queryResult);
        ruleQuery.setQryExecStatus(String.valueOf(runStatus));
        if (runStatus.equalsIgnoreCase("-1")) {
            BaseRule.handleErrorCase(ruleQuery, queryResult);
            return ruleQuery;
        }
        JSONArray results = QueryExecutor.getRunJson(queryResult);
        if (results.size() > 0) {
            ruleQuery.setColumnseq(QueryExecutor.getKeyOrders(queryResult));
        }
        ruleQuery.setQryResultCnt(results.size());
        ruleQuery.setQryExecStatus("0");
        this.postBackResultsHandler(results, ruleQuery);
        return ruleQuery;
    }

    public void postBackResultsHandler(JSONArray results, SqlQuery ruleQuery) {
        if (ruleQuery.isPostBackJson()) {
            logger.info(this.logFormat.getFormattedLog(), "Posting back json results in the Node metadata for Query Id : ", ruleQuery.getQryId());
            ruleQuery.setQryOutput(results);
        } else {
            logger.info(this.logFormat.getFormattedLog(), "Writing json results in files for Query Id : ", ruleQuery.getQryId());
            results = this.applyLimitOnResults(results, ruleQuery);
            String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
            String filePath = this.fileUploadHandler(isCloudSAWS, this.getOutputFileName(ruleQuery), results);
            JSONArray filePathJson = this.generateFilePathObject(filePath);
            ruleQuery.setQryOutput(filePathJson);
        }
    }

    private JSONArray applyLimitOnResults(JSONArray results, SqlQuery ruleQuery) {
        JSONArray limitedRecords = new JSONArray();
        if (ruleQuery.getRecordLimit() < results.size()) {
            int index = 0;
            while (index < ruleQuery.getRecordLimit()) {
                limitedRecords.add(results.get(index));
                ++index;
            }
        } else {
            limitedRecords = results;
        }
        return limitedRecords;
    }

    public String getOutputFileName(SqlQuery ruleQuery) {
        return String.valueOf(this.node.getRuleId()) + "_" + ruleQuery.getQryId() + "_output.json";
    }

    public String fileUploadHandler(String isCloudSAWS, String fileName, JSONArray results) {
        String queryOutputFilePath = String.valueOf(this.baseFilePath) + fileName;
        FileUtil.writeToFileIfNotExists(queryOutputFilePath, this.encryptText(results.toJSONString()));
        String filePathToReturn = queryOutputFilePath;
        if ("false".equalsIgnoreCase(isCloudSAWS)) {
            logger.info(this.logFormat.getFormattedLog(), "On-Prem SAWS : Storing query output files in local file system");
        } else {
            logger.info(this.logFormat.getFormattedLog(), "Cloud SAWS : Uploading query output files to S3");
            String compressedQueryOutputFilePath = JsonUtil.compressJsonFile(queryOutputFilePath);
            MultipartFileUploader.uploadFileToS3(compressedQueryOutputFilePath, this.s3PreSignedURLInfo, this.logFormat);
            filePathToReturn = NodeExecutionMetadata.getModifiedKeyFromS3PresignedPostUrl(this.s3PreSignedURLInfo, BaseRule.extractFileNameFromPath(compressedQueryOutputFilePath));
        }
        return filePathToReturn;
    }

    public void dumpWebsocketMessageToS3(JSONObject websocketMessage, String fileName) {
        String filePath = String.valueOf(this.baseFilePath) + fileName;
        FileUtil.writeToFileIfNotExists(filePath, websocketMessage.toJSONString());
        MultipartFileUploader.uploadFileToS3(filePath, this.s3PreSignedURLInfo, this.logFormat);
        this.websocketMessageS3FilePath = NodeExecutionMetadata.getModifiedKeyFromS3PresignedPostUrl(this.s3PreSignedURLInfo, fileName);
    }

    public JSONObject findQueryResultsByQueryType(String queryType) {
        JSONObject requiredQueryResults = new JSONObject();
        for (Object queryResultsObj : this.queryResultsJsonArray) {
            JSONObject queryResultsJson = (JSONObject)queryResultsObj;
            if (!String.valueOf(queryResultsJson.get((Object)"queryType")).equalsIgnoreCase(queryType)) continue;
            requiredQueryResults = queryResultsJson;
            break;
        }
        return requiredQueryResults;
    }

    public JSONObject findQueryResultsByQueryType(String queryType, String colId) {
        JSONObject requiredQueryResults = new JSONObject();
        for (Object queryResultsObj : this.queryResultsJsonArray) {
            JSONObject queryResultsJson = (JSONObject)queryResultsObj;
            if (!String.valueOf(queryResultsJson.get((Object)"queryType")).equalsIgnoreCase(queryType) || !String.valueOf(queryResultsJson.get((Object)"queryId")).equalsIgnoreCase(colId)) continue;
            requiredQueryResults = queryResultsJson;
            break;
        }
        return requiredQueryResults;
    }

    public static void handleErrorCase(SqlQuery ruleQuery, JSONObject queryResults) {
        ruleQuery.setQryErrorMsg(QueryExecutor.getRunError(queryResults));
    }

    public static <T> String extractFileNameFromPath(T filePath) {
        String[] parts = filePath.toString().split("/");
        return parts[parts.length - 1];
    }

    public JSONArray generateFilePathObject(String filePath) {
        JSONObject filePathJson = new JSONObject();
        filePathJson.put((Object)"file_path", (Object)filePath);
        JSONArray filePathJsonArray = new JSONArray();
        filePathJsonArray.add((Object)filePathJson);
        return filePathJsonArray;
    }

    public void sendMessageToWebsocket() {
        JSONObject message = new JSONObject();
        message.put((Object)"file_path", (Object)this.websocketMessageS3FilePath);
        message.put((Object)"job_id", (Object)this.node.getJobId());
        message.put((Object)"is_job_online", (Object)this.node.getIsJobOnline());
        message.put((Object)"ui_websocket_id", (Object)this.node.getUiWebsocketId());
        message.put((Object)"connector_details", (Object)this.connector.toJSON());
        JSONObject websocketMessage = new JSONObject();
        websocketMessage.put((Object)"context", (Object)"jobQuery");
        websocketMessage.put((Object)"source", (Object)"dvsumConnector");
        websocketMessage.put((Object)"type", (Object)"URL");
        websocketMessage.put((Object)"message", (Object)message);
        logger.info(this.logFormat.getFormattedLog(), "Sending websocket message ", websocketMessage.toJSONString());
        ConnectionManager.sendWebsocketMessageWithRetry(websocketMessage);
    }

    public String encryptText(String text) {
        String encryptedText = text;
        String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
        if ("false".equalsIgnoreCase(isCloudSAWS)) {
            encryptedText = CryptographicUtil.encrypt(encryptedText);
        }
        return encryptedText;
    }

    public String getModifiedFileName(String name) {
        return name.replace(".", "_").replace(" ", "_").replaceAll("[\\[\\]\"`]", "");
    }

    public String getModifiedKey(String key) {
        return key.toLowerCase().replaceAll("[\\[\\]\"`]", "");
    }
}

