/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.model;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.Executable;
import com.dvsum.model.QueryExecutor;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.json.simple.JSONObject;

public class ProfilingRule
extends Executable {
    private static final CustomLogger logger = CustomLogger.getLogger(ProfilingRule.class);
    private JSONObject masterRule;
    private ArrayList<String> masterResultList = new ArrayList();

    public ProfilingRule(ExecutorService executorService, DataSourceFactory dataSourceFactory, String certType, String postURL, LogFormat logFormat) {
        super(executorService, dataSourceFactory, certType, postURL, logFormat);
    }

    public void addNormalRule(JSONObject rule) {
        super.getDbInfoAndQueryList().add((Object)rule);
    }

    public void addMasterRule(JSONObject Rule) {
        this.masterRule = Rule;
    }

    public void addRule(JSONObject rule) {
        String type = String.valueOf(rule.get((Object)"SAWSSequence"));
        if (rule.get((Object)"resultLimit") == null) {
            rule.put((Object)"resultLimit", (Object)"1000000");
        }
        switch (type) {
            case "100": {
                this.addMasterRule(rule);
                break;
            }
            default: {
                this.addNormalRule(rule);
            }
        }
    }

    @Override
    public void execute() {
        this.excuteMasterRule();
    }

    public void excuteMasterRule() {
        if (this.masterRule != null && this.getExecutor() != null) {
            logger.debug("Executing Master");
            QueryExecutor queryExecutor = new QueryExecutor(this.getDataSourceFactory(), this.masterRule, false, this.logFormat);
            this.getExecutor().submit(queryExecutor);
        }
    }

    @Override
    public void executeDependents() {
        int i = 0;
        while (i < this.getDbInfoAndQueryList().size()) {
            logger.debug("Executing Dependents");
            QueryExecutor queryExecutor = new QueryExecutor(this.getDataSourceFactory(), (JSONObject)this.getDbInfoAndQueryList().get(i), false, this.logFormat);
            this.getExecutor().submit(queryExecutor);
            ++i;
        }
    }
}

