/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.logger;

import com.dvsum.logger.ChatLogFormat;
import com.dvsum.logger.LogFormat;
import com.dvsum.logger.RuleLogFormat;
import com.dvsum.logger.ScanLogFormat;
import com.dvsum.util.Util;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.json.simple.JSONObject;

public class CustomLogger {
    public Logger logger;
    private LogFormat logFormat;

    protected CustomLogger(Logger logger) {
        this.logger = logger;
        this.logFormat = this.getLogFormatFromLogType(null);
    }

    protected CustomLogger(Logger logger, String logType) {
        this.logger = logger;
        this.logFormat = this.getLogFormatFromLogType(logType);
    }

    protected void setLogFormat(String logType, String executionId, String sourceId, String sourceName) {
        this.logFormat = this.getLogFormatFromLogType(logType);
    }

    public void setLogFormat(String logType, JSONObject data) {
        this.logFormat.setLogFormat(logType, data);
    }

    public LogFormat getLogFormat() {
        return this.logFormat;
    }

    protected LogFormat getLogFormatFromLogType(String logType) {
        LogFormat logFormat = new LogFormat();
        if (Util.isNullOrEmpty(logType)) {
            return logFormat;
        }
        switch (logType) {
            case "scan": {
                this.logFormat = new ScanLogFormat();
                break;
            }
            case "chat": {
                this.logFormat = new ChatLogFormat();
                break;
            }
            case "rule": {
                this.logFormat = new RuleLogFormat();
            }
        }
        return logFormat;
    }

    public static CustomLogger getLogger(Class<?> clazz) {
        return new CustomLogger(LogManager.getLogger(clazz), null);
    }

    public static CustomLogger getLogger(Class<?> clazz, String logType) {
        return new CustomLogger(LogManager.getLogger(clazz), logType);
    }

    public static CustomLogger getLogger(String name) {
        return new CustomLogger(LogManager.getLogger((String)name));
    }

    public void setLevel(Level level) {
        Configurator.setLevel((String)this.logger.getName(), (Level)level);
    }

    public void info(Object ... messages) {
        String formattedMessage = this.formatLogMessage(messages);
        this.logger.info(formattedMessage);
    }

    public void debug(Object ... messages) {
        String formattedMessage = this.formatLogMessage(messages);
        this.logger.debug(formattedMessage);
    }

    public void error(Object ... messages) {
        String formattedMessage = this.formatLogMessage(messages);
        this.logger.error(formattedMessage);
    }

    public void warn(Object ... messages) {
        String formattedMessage = this.formatLogMessage(messages);
        this.logger.warn(formattedMessage);
    }

    private String formatLogMessage(Object ... messages) {
        StringBuilder formattedMessage = new StringBuilder();
        Object[] objectArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Object message = objectArray[n2];
            formattedMessage.append(message).append(" ");
            ++n2;
        }
        return formattedMessage.toString();
    }
}

