/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.initializer;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.DateUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.TemplateLoader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import org.apache.jasper.servlet.JspServlet;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.apache.jsp.JettyJasperInitializer;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.json.simple.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class EmbeddedJetty {
    private static final CustomLogger logger = CustomLogger.getLogger(EmbeddedJetty.class);
    public static String KEYSTORE_PATH = "./localhost.jks";
    public static String KEYSTORE_PASS = "dvsum@emumba";
    public static String KEYSTORE_ALIAS = "jetty";
    public static String CONFIGURATION_PATH = "./configuration.properties";
    public static String ACTIVEMQ_CONFIGURATION_PATH = "./activemq_configuration.properties";
    public static String POLLING_URLS_PATH = "polling-urls.properties";
    public static int HTTP_PORT = 8182;
    public static int HTTPS_PORT = 8183;
    private static final String CONTEXT_PATH = "/";
    private static final String CONFIG_LOCATION = "com.dvsum.config.AppConfig";
    private static final String MAPPING_URL = "/";
    private static final String DEFAULT_PROFILE = "dev";
    public static boolean SCHEDULE_UPDATE = false;
    public static boolean SCHEDULE_REBOOT = false;
    public static Integer NUM_OF_THREADS = 10;
    public static String SERVER_START_TIME = null;
    private static Server jettyServer = null;

    public static void main(String[] args) throws Exception {
        logger.info("SAWS boot time: " + DateUtil.getCurrentTimeInTwentyFourHourFormate());
        Locale.setDefault(Locale.ENGLISH);
        EmbeddedJetty.setupConfigs();
        EmbeddedJetty.startSAWSJetty();
    }

    public static void setupConfigs() {
        logger.info("Setting up certificate");
        try {
            JSONObject certProps = FileUtil.getProperties("./ssl_config.properties", new String[]{"keystore_path", "keystore_pass"});
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                System.out.println("Operating system is Windows");
                KEYSTORE_PATH = !certProps.isEmpty() && certProps.containsKey((Object)"keystore_path") ? String.valueOf(certProps.get((Object)"keystore_path")) : "./keystore.jks";
                KEYSTORE_ALIAS = !certProps.isEmpty() && certProps.containsKey((Object)"alias") ? String.valueOf(certProps.get((Object)"alias")) : null;
            } else {
                System.out.println("Operating system is not Windows");
                KEYSTORE_PATH = !certProps.isEmpty() && certProps.containsKey((Object)"keystore_path") ? "./" + String.valueOf(certProps.get((Object)"keystore_path")) : "./keystore.jks";
                KEYSTORE_ALIAS = !certProps.isEmpty() && certProps.containsKey((Object)"alias") ? "./" + String.valueOf(certProps.get((Object)"alias")) : null;
            }
            System.out.println(KEYSTORE_PATH);
            KEYSTORE_PASS = EmbeddedJetty.getKeyStorePassword(certProps);
            BasicConfigurator.configure();
            FileUtil.setDefaultConfigurations();
            FileUtil.setHttpPortsFromConfigFile();
        }
        catch (Exception e) {
            logger.error("Error while setting up configs. Error:", e.getMessage());
            e.printStackTrace();
        }
    }

    public static String getKeyStorePassword(JSONObject certProps) {
        String envPassword = System.getenv("KEYSTORE_PASSWORD");
        if (envPassword != null && !envPassword.isEmpty()) {
            String decryptedEnvPassword = CryptographicUtil.decrypt(envPassword);
            return decryptedEnvPassword != null ? decryptedEnvPassword : envPassword;
        }
        if (certProps != null && certProps.containsKey((Object)"keystore_pass")) {
            String passStr = String.valueOf(certProps.get((Object)"keystore_pass"));
            String decryptedPassword = CryptographicUtil.decrypt(passStr);
            return decryptedPassword != null ? decryptedPassword : passStr;
        }
        return "dvsum@emumba";
    }

    public static void startSAWSJetty() throws Exception {
        logger.info("Starting Jetty at " + HTTPS_PORT + " port");
        new EmbeddedJetty().startJetty();
    }

    private static int getPortFromArgs(String[] args) {
        if (args.length > 0) {
            try {
                return Integer.valueOf(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return HTTP_PORT;
    }

    private static void setJetty(Server server) {
        jettyServer = server;
    }

    public static void restartJetty() {
        try {
            EmbeddedJetty.stopJetty(null);
            EmbeddedJetty.setupConfigs();
            EmbeddedJetty.startSAWSJetty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopJetty(String[] args) {
        try {
            logger.info("Stopping  jetty ................ ");
            FileUtil.setSAWSMaintenaceFlagToTrue();
            jettyServer.stop();
            jettyServer.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startJetty() throws Exception {
        Server server = new Server();
        EmbeddedJetty.setJetty(server);
        System.setProperty("org.apache.jasper.compiler.disablejsr199", "false");
        server.setConnectors(new Connector[]{this.getSSLConnector(server)});
        WebAppContext context = EmbeddedJetty.getServletContextHandler(EmbeddedJetty.getContext());
        context.setMaxFormContentSize(100000000);
        this.setupJspHandler(context);
        server.setHandler((Handler)context);
        server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)"100000000");
        server.start();
        SERVER_START_TIME = DateUtil.getDate("MM/dd/yy HH:mm a");
        server.join();
    }

    private ServerConnector getSSLConnector(Server server) throws IOException {
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(KEYSTORE_PATH);
        sslContextFactory.setKeyStorePassword(KEYSTORE_PASS);
        sslContextFactory.setKeyManagerPassword(KEYSTORE_PASS);
        if (KEYSTORE_ALIAS != null && !KEYSTORE_ALIAS.isEmpty()) {
            logger.info("using keystore alias: ", KEYSTORE_ALIAS);
            sslContextFactory.setCertAlias(KEYSTORE_ALIAS);
        }
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        sslConnector.setPort(HTTPS_PORT);
        return sslConnector;
    }

    private static WebAppContext getServletContextHandler(WebApplicationContext context) throws IOException {
        WebAppContext contextHandler = new WebAppContext();
        contextHandler.setErrorHandler(null);
        contextHandler.setContextPath("/");
        contextHandler.addServlet(new ServletHolder((Servlet)new DispatcherServlet(context)), "/");
        contextHandler.addEventListener((EventListener)new ContextLoaderListener(context));
        contextHandler.setResourceBase(new ClassPathResource("webapp").getURI().toString());
        TemplateLoader templateLoader = new TemplateLoader();
        templateLoader.updateConfiguration();
        return contextHandler;
    }

    private static WebApplicationContext getContext() {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.setConfigLocation(CONFIG_LOCATION);
        context.getEnvironment().setDefaultProfiles(new String[]{DEFAULT_PROFILE});
        return context;
    }

    private void setupJspHandler(WebAppContext context) {
        JettyJasperInitializer sci = new JettyJasperInitializer();
        ServletContainerInitializersStarter sciStarter = new ServletContainerInitializersStarter(context);
        ContainerInitializer initializer = new ContainerInitializer((ServletContainerInitializer)sci, null);
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(initializer);
        context.setAttribute("org.eclipse.jetty.containerInitializers", initializers);
        context.addBean((Object)sciStarter, true);
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        context.setClassLoader((ClassLoader)jspClassLoader);
        ServletHolder holderJsp = new ServletHolder("jsp", JspServlet.class);
        holderJsp.setInitOrder(0);
        holderJsp.setInitParameter("logVerbosityLevel", "INFO");
        holderJsp.setInitParameter("fork", "false");
        holderJsp.setInitParameter("xpoweredBy", "false");
        holderJsp.setInitParameter("compilerTargetVM", "1.7");
        holderJsp.setInitParameter("compilerSourceVM", "1.7");
        holderJsp.setInitParameter("keepgenerated", "true");
        context.addServlet(holderJsp, "*.jsp");
    }
}

