/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.factory;

import com.dvsum.cdatasource.AmazonS3Source;
import com.dvsum.cdatasource.DatabricksSource;
import com.dvsum.cdatasource.MongoDBSource;
import com.dvsum.cdatasource.SalesforceSource;
import com.dvsum.dataSource.AzureSqlDataSource;
import com.dvsum.dataSource.AzureSynapseDataSource;
import com.dvsum.dataSource.DB2DataSource;
import com.dvsum.dataSource.DataSource;
import com.dvsum.dataSource.DatabricksNativeSource;
import com.dvsum.dataSource.MsSqlDataSource;
import com.dvsum.dataSource.MySqlDataSource;
import com.dvsum.dataSource.NetezzaSource;
import com.dvsum.dataSource.OracleDataSource;
import com.dvsum.dataSource.PostgreSQLDataSource;
import com.dvsum.dataSource.SnowflakeNativeSource;
import com.dvsum.logger.LogFormat;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class DataSourceFactory {
    public DataSource getDataSource(String sourceType, JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        switch (sourceType) {
            case "ORC": {
                return new OracleDataSource(DBInfo, isCataloging, logFormat);
            }
            case "MSQ": {
                return new MySqlDataSource(DBInfo, isCataloging, logFormat);
            }
            case "DB2": {
                return new DB2DataSource(DBInfo, isCataloging, logFormat);
            }
            case "MSS": {
                return new MsSqlDataSource(DBInfo, isCataloging, logFormat);
            }
            case "ASQ": {
                return new AzureSqlDataSource(DBInfo, isCataloging, logFormat);
            }
            case "SNF": {
                return new SnowflakeNativeSource(DBInfo, isCataloging, logFormat);
            }
            case "SFN": {
                return new SnowflakeNativeSource(DBInfo, isCataloging, logFormat);
            }
            case "SNP": {
                return new AzureSynapseDataSource(DBInfo, isCataloging, logFormat);
            }
            case "SLF": {
                return new SalesforceSource(DBInfo, isCataloging, logFormat);
            }
            case "AS3": {
                return new AmazonS3Source(DBInfo, isCataloging, logFormat);
            }
            case "DBS": {
                return new DatabricksSource(DBInfo, isCataloging, logFormat);
            }
            case "DBN": {
                return new DatabricksNativeSource(DBInfo, isCataloging, logFormat);
            }
            case "PSQ": {
                return new PostgreSQLDataSource(DBInfo, isCataloging, logFormat);
            }
            case "MDB": {
                return new MongoDBSource(DBInfo, isCataloging, logFormat);
            }
            case "NTZ": {
                return new NetezzaSource(DBInfo, isCataloging, logFormat);
            }
        }
        return null;
    }
}

