/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.Util;
import org.json.simple.JSONObject;

public class SnowflakeNativeSource
extends DataSource {
    private static final CustomLogger logger = CustomLogger.getLogger(SnowflakeNativeSource.class);
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";

    public SnowflakeNativeSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public SnowflakeNativeSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "com.snowflake.client.jdbc.SnowflakeDriver";
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        if (Util.isNullOrEmpty(this.connectionString)) {
            strBuilder.append("jdbc:snowflake://");
            strBuilder.append(String.valueOf(this.url) + (this.url.trim().endsWith("/") ? "?" : "/?"));
            strBuilder.append("warehouse=" + this.warehouse);
            strBuilder.append("&database=" + (Util.isNotNullOrEmpty(this.database) ? this.database : "SNOWFLAKE"));
            strBuilder.append("&role=" + (Util.isNotNullOrEmpty(this.roleName) ? this.roleName : "PUBLIC"));
            strBuilder.append("&loginTimeout=60");
            strBuilder.append("&queryTimeout=600");
            strBuilder.append("&networkTimeout=600");
            strBuilder = new StringBuilder(String.valueOf(this.addOptionalProps(this.optionalParams, strBuilder.toString())));
        } else {
            strBuilder.append(this.connectionString);
        }
        return strBuilder.toString();
    }
}

