/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.json.simple.JSONObject;

public class PostgreSQLDataSource
extends DataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    private int cursorIndex;

    @Override
    public void initializeConnectionParameters(JSONObject dataSourceInfoAndQuery) {
        super.initializeConnectionParameters(dataSourceInfoAndQuery);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
    }

    public PostgreSQLDataSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.isCataloging = isCataloging;
    }

    public PostgreSQLDataSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "org.postgresql.Driver";
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        if (Util.isNullOrEmpty(this.connectionString)) {
            strBuilder.append("jdbc:postgresql://");
            strBuilder.append(this.host);
            strBuilder.append(":" + this.port + "/");
            if (Util.isNotNullOrEmpty(this.database)) {
                strBuilder.append(this.database);
            }
            strBuilder = new StringBuilder(String.valueOf(this.addOptionalProps(this.optionalParams, strBuilder.toString())));
        } else {
            strBuilder.append(this.connectionString);
        }
        return strBuilder.toString();
    }

    @Override
    public void prepareCallableStatment(String queryString) throws SQLException {
        Character last;
        String procName = null;
        String params = null;
        String[] paramsArray = new String[]{};
        String query = !Util.isNullOrEmpty(queryString) ? queryString.replaceAll(",", "  ,") : "";
        if ((query = query.toLowerCase().replace("call ", "").replace("execute ", "")).contains("(") && query.contains(")")) {
            procName = query.trim().substring(0, query.indexOf("("));
            params = query.trim().substring(query.indexOf("(") + 1, query.indexOf(")"));
            paramsArray = !Util.isNullOrEmptyTrimmed(params) ? params.split(",") : new String[]{};
        } else {
            procName = queryString;
        }
        this.inputPramasLength = paramsArray != null ? paramsArray.length : 0;
        this.cursorIndex = this.inputPramasLength + 1;
        StringBuilder procParam = new StringBuilder();
        int i = 0;
        while (i < paramsArray.length) {
            if (paramsArray[i].trim().equalsIgnoreCase("\":x\"") || paramsArray[i].trim().equalsIgnoreCase("':x'")) {
                this.cursorIndex = i + 1;
            } else {
                String paramPlaceHolder = i < paramsArray.length - 1 ? "?," : "?";
                procParam.append(paramPlaceHolder);
            }
            ++i;
        }
        String parameters = procParam.toString();
        if (!Util.isNullOrEmptyTrimmed(parameters) && (last = Character.valueOf(parameters.charAt(parameters.length() - 1))).equals(Character.valueOf(','))) {
            parameters = procParam.substring(0, procParam.toString().length() - 1);
        }
        String proc = Util.isNullOrEmpty(parameters) ? "{call " + procName + "(?) }" : "{call " + procName + "(" + parameters + ",?) }";
        this.callableStatement = this.connection.prepareCall(proc);
        this.setInputParams(paramsArray);
        this.inputPramasLength = this.cursorIndex;
        this.callableStatement.registerOutParameter(this.cursorIndex, -10);
    }

    @Override
    public int getInputParamsLength() {
        return this.inputPramasLength;
    }

    @Override
    public ResultSet executeProc(String query) throws SQLException {
        this.callableStatement.execute();
        return (ResultSet)this.callableStatement.getObject(this.cursorIndex);
    }
}

