/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import java.util.Properties;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ParameterAppender {
    public String processOptionalParams(String connectionString, Object paramObj) {
        if (paramObj == null) {
            return connectionString;
        }
        StringBuilder result = new StringBuilder(connectionString);
        try {
            boolean isFirst;
            boolean bl = isFirst = !connectionString.contains("?");
            if (paramObj instanceof String) {
                JSONArray optionalParams = (JSONArray)new JSONParser().parse((String)paramObj);
                for (Object param : optionalParams) {
                    JSONObject paramJson = (JSONObject)param;
                    String key = String.valueOf(paramJson.get((Object)"key"));
                    String value = String.valueOf(paramJson.get((Object)"value"));
                    if (key == null || key.isEmpty() || value == null || value.isEmpty()) continue;
                    result.append(isFirst ? "?" : "&");
                    result.append(key).append("=").append(value);
                    isFirst = false;
                }
            } else if (paramObj instanceof Properties) {
                Properties props = (Properties)paramObj;
                for (String key : props.stringPropertyNames()) {
                    String value = props.getProperty(key);
                    if (key == null || key.isEmpty() || value == null || value.isEmpty()) continue;
                    result.append(isFirst ? "?" : "&");
                    result.append(key).append("=").append(value);
                    isFirst = false;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static void main(String[] args) {
        ParameterAppender appender = new ParameterAppender();
        String connectionString = "https://api.example.com/data";
        String jsonInput = "[{\"key\":\"server\", \"value\":\"192.168.1.1\"}, {\"key\":\"port\", \"value\":\"8080\"}]";
        Properties props = new Properties();
        props.setProperty("server", "192.168.1.1");
        props.setProperty("port", "8080");
        String resultFromJson = appender.processOptionalParams(connectionString, jsonInput);
        String resultFromProperties = appender.processOptionalParams(connectionString, props);
        System.out.println("Result from JSON: " + resultFromJson);
        System.out.println("Result from Properties: " + resultFromProperties);
    }
}

