/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.util.Properties;
import org.json.simple.JSONObject;

public class NetezzaSource
extends DataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    private Properties props = new Properties();

    public NetezzaSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public NetezzaSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "org.netezza.Driver";
    }

    @Override
    public String getURL() {
        return "jdbc:netezza://" + this.host + ":5480/" + (Util.isNotNullOrEmpty(this.database) ? this.database : "SYSTEM") + ";";
    }

    @Override
    public void connect() throws Exception {
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            Class.forName(this.getDriver());
            this.props.setProperty("user", this.userName);
            this.props.setProperty("password", this.password);
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }
}

