/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.FileUtil;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import org.json.simple.JSONObject;

public class MySqlDataSource
extends DataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    private static final CustomLogger logger = CustomLogger.getLogger(MySqlDataSource.class);

    public MySqlDataSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public MySqlDataSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return null;
    }

    @Override
    public void connect() throws Exception {
        StatusUtil.incerementConnectionCount();
        String connStr = this.getURL();
        logger.info("MySQL: Connection string: ", connStr);
        this.connection = DriverManager.getConnection(connStr, this.userName, this.password);
    }

    @Override
    public String getURL() {
        StringBuilder strBuilder = new StringBuilder();
        if (Util.isNullOrEmpty(this.connectionString)) {
            strBuilder.append("jdbc:mysql://");
            strBuilder.append(String.valueOf(this.host != null ? this.host : "") + ":");
            strBuilder.append(String.valueOf(this.port != null ? this.port : "") + "/");
            if (Util.isNotNullOrEmpty(this.schemaName)) {
                strBuilder.append(this.schemaName);
            }
            StringBuilder params = new StringBuilder();
            if (!this.useBasicAuthentication && this.useSSL != null && this.useSSL.equalsIgnoreCase("true")) {
                params.append("useSSL=").append(this.useSSL);
                params.append("&requireSSL=").append(this.requireSSL);
                params.append("&verifyServerCertificate=").append(this.verifyServerCertificate);
                params.append("&trustCertificateKeyStoreUrl=").append(this.trustCertificateKeyStoreUrl != null ? this.trustCertificateKeyStoreUrl : "");
                params.append("&trustCertificateKeyStorePassword=").append(this.trustCertificateKeyStorePassword != null ? this.trustCertificateKeyStorePassword : "");
            }
            if (params.length() > 0) {
                strBuilder.append("?").append((CharSequence)params);
            }
            strBuilder = new StringBuilder(String.valueOf(this.addOptionalProps(this.optionalParams, strBuilder.toString())));
        } else {
            strBuilder.append(this.connectionString);
        }
        return strBuilder.toString();
    }

    private String getOptionalParams() {
        String optionalParams = "";
        String optionalPropsKey = "mysql.optional_conn_params";
        if (FileUtil.checkIfPropertyExists(optionalPropsKey)) {
            optionalParams = FileUtil.getProperty(optionalPropsKey);
        }
        return optionalParams;
    }
}

