/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.dataSource.DataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.json.simple.JSONObject;

public class DatabricksNativeSource
extends DataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    private static final CustomLogger logger = CustomLogger.getLogger(DatabricksNativeSource.class);
    private Properties props = new Properties();

    public DatabricksNativeSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public DatabricksNativeSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "com.databricks.client.jdbc.Driver";
    }

    @Override
    public String getURL() {
        return "jdbc:databricks://" + this.host + ":443";
    }

    @Override
    public void connect() throws Exception {
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            this.props.setProperty("httpPath", this.httpPath);
            if (this.authScheme.equalsIgnoreCase("AzureServicePrincipal")) {
                this.props.setProperty("AuthMech", "11");
                this.props.setProperty("Auth_Flow", "1");
                this.props.setProperty("OAuth2ClientId", this.clientId);
                this.props.setProperty("OAuth2Secret", this.oAuthSecret);
            } else if (this.authScheme.equalsIgnoreCase("PersonalAccessToken")) {
                this.props.setProperty("AuthMech", "3");
                this.props.setProperty("UID", "token");
                this.props.setProperty("PWD", this.secretKey);
            }
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }

    public Boolean isWarehousesExistsInHttpPath() {
        return this.httpPath.contains("warehouses");
    }

    public void executeSampleQuery() throws SQLException {
        Statement stmt = this.connection.createStatement();
        stmt.executeQuery("SELECT 1");
    }
}

