/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.dataSource;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public abstract class DataSource {
    private static final CustomLogger logger = CustomLogger.getLogger(DataSource.class);
    protected String type;
    protected String userName;
    protected String password;
    protected JSONArray dataSourceInfoWithQuery = new JSONArray();
    public Connection connection;
    protected PreparedStatement preparedStatement;
    protected Statement statement;
    protected CallableStatement callableStatement;
    protected ResultSet resultSet;
    protected String query;
    protected int inputPramasLength;
    protected String fileSystemPath;
    protected String stagingBucket;
    protected String s3StagingBucketfolderPath;
    protected String sawsOperation;
    protected String host;
    protected String port;
    protected String serviceId;
    protected String schemaName;
    protected String database;
    protected String sourceId;
    protected String clientId;
    protected String accessKey;
    protected String secretKey;
    protected String region;
    protected String glueCrawler;
    protected String roleName;
    protected String projectId;
    protected String datasetId;
    protected String biqQueryJWT;
    protected String url;
    protected boolean isTestConnection;
    protected String warehouse;
    protected String testConnectionQuery;
    protected boolean isCataloging;
    protected String instance_name;
    protected String httpPath;
    protected String authScheme;
    protected String tenantId;
    protected String clientSecret;
    protected String oAuthSecret;
    protected String subscriptionId;
    protected String resourceGroup;
    protected String workspace;
    protected String useSSL;
    protected String authDatabase;
    protected boolean isOnCloud;
    protected String verifierCode;
    protected String useSandbox;
    protected String loginURL;
    protected String authSettings;
    protected LogFormat logFormat;
    protected boolean requireSSL;
    protected String trustCertificateKeyStoreUrl;
    protected String trustCertificateKeyStorePassword;
    protected boolean verifyServerCertificate;
    protected boolean useBasicAuthentication;
    protected String connectionString;
    protected String optionalParams;

    DataSource(LogFormat logFormat) {
        this.logFormat = logFormat;
    }

    public void initializeConnectionParameters(JSONObject dataSourceInfoAndQueryObject) {
        this.inputPramasLength = 0;
        try {
            Boolean isTestCon;
            JSONObject connectionJson = dataSourceInfoAndQueryObject;
            if (connectionJson.containsKey((Object)"connection_string") && connectionJson.get((Object)"connection_string") != null) {
                this.connectionString = String.valueOf(connectionJson.get((Object)"connection_string"));
            }
            if (connectionJson.containsKey((Object)"optional_params") && connectionJson.get((Object)"optional_params") != null) {
                this.optionalParams = String.valueOf(connectionJson.get((Object)"optional_params"));
            }
            if (connectionJson.containsKey((Object)"use_basic_authentication") && connectionJson.get((Object)"use_basic_authentication") != null) {
                this.useBasicAuthentication = Boolean.valueOf(String.valueOf(connectionJson.get((Object)"use_basic_authentication")));
            }
            if (connectionJson.containsKey((Object)"require_ssl") && connectionJson.get((Object)"require_ssl") != null) {
                this.requireSSL = Boolean.valueOf(String.valueOf(connectionJson.get((Object)"require_ssl")));
            }
            if (connectionJson.containsKey((Object)"trust_certificate_key_store_url") && connectionJson.get((Object)"trust_certificate_key_store_url") != null) {
                this.trustCertificateKeyStoreUrl = String.valueOf(connectionJson.get((Object)"trust_certificate_key_store_url"));
            }
            if (connectionJson.containsKey((Object)"trust_certificate_key_store_password") && connectionJson.get((Object)"trust_certificate_key_store_password") != null) {
                this.trustCertificateKeyStorePassword = String.valueOf(connectionJson.get((Object)"trust_certificate_key_store_password"));
            }
            if (connectionJson.containsKey((Object)"verify_server_certificate") && connectionJson.get((Object)"verify_server_certificate") != null) {
                this.verifyServerCertificate = Boolean.valueOf(String.valueOf(connectionJson.get((Object)"verify_server_certificate")));
            }
            if (connectionJson.containsKey((Object)"AuthScheme") && connectionJson.get((Object)"AuthScheme") != null) {
                this.authScheme = String.valueOf(connectionJson.get((Object)"AuthScheme"));
            }
            if (connectionJson.containsKey((Object)"auth_scheme") && connectionJson.get((Object)"auth_scheme") != null) {
                this.authScheme = String.valueOf(connectionJson.get((Object)"auth_scheme"));
            }
            if (connectionJson.containsKey((Object)"authSettings") && connectionJson.get((Object)"authSettings") != null) {
                this.authSettings = String.valueOf(connectionJson.get((Object)"authSettings"));
            }
            if (connectionJson.containsKey((Object)"use_ssl") && connectionJson.get((Object)"use_ssl") != null) {
                this.useSSL = String.valueOf(connectionJson.get((Object)"use_ssl"));
            }
            if (connectionJson.containsKey((Object)"auth_database") && connectionJson.get((Object)"auth_database") != null) {
                this.authDatabase = String.valueOf(connectionJson.get((Object)"auth_database"));
            }
            if (connectionJson.containsKey((Object)"AzureTenantId") && connectionJson.get((Object)"AzureTenantId") != null) {
                this.tenantId = String.valueOf(connectionJson.get((Object)"AzureTenantId"));
            }
            if (connectionJson.containsKey((Object)"AzureClientId") && connectionJson.get((Object)"AzureClientId") != null) {
                this.clientId = String.valueOf(connectionJson.get((Object)"AzureClientId"));
            }
            if (connectionJson.containsKey((Object)"AzureClientSecret") && connectionJson.get((Object)"AzureClientSecret") != null) {
                this.clientSecret = String.valueOf(connectionJson.get((Object)"AzureClientSecret"));
            }
            if (connectionJson.containsKey((Object)"OAuthSecret") && connectionJson.get((Object)"OAuthSecret") != null) {
                this.oAuthSecret = String.valueOf(connectionJson.get((Object)"OAuthSecret"));
            }
            if (connectionJson.containsKey((Object)"verifierCode") && connectionJson.get((Object)"verifierCode") != null) {
                this.verifierCode = String.valueOf(connectionJson.get((Object)"verifierCode"));
            }
            if (connectionJson.containsKey((Object)"useSandbox") && connectionJson.get((Object)"useSandbox") != null) {
                this.useSandbox = String.valueOf(connectionJson.get((Object)"useSandbox"));
            }
            if (connectionJson.containsKey((Object)"loginURL") && connectionJson.get((Object)"loginURL") != null) {
                this.loginURL = String.valueOf(connectionJson.get((Object)"loginURL"));
            }
            if (connectionJson.containsKey((Object)"AzureSubscriptionId") && connectionJson.get((Object)"AzureSubscriptionId") != null) {
                this.subscriptionId = String.valueOf(connectionJson.get((Object)"AzureSubscriptionId"));
            }
            if (connectionJson.containsKey((Object)"AzureResourceGroup") && connectionJson.get((Object)"AzureResourceGroup") != null) {
                this.resourceGroup = String.valueOf(connectionJson.get((Object)"AzureResourceGroup"));
            }
            if (connectionJson.containsKey((Object)"AzureWorkspace") && connectionJson.get((Object)"AzureWorkspace") != null) {
                this.workspace = String.valueOf(connectionJson.get((Object)"AzureWorkspace"));
            }
            if (connectionJson.containsKey((Object)"source_id") && connectionJson.get((Object)"source_id") != null) {
                this.sourceId = String.valueOf(connectionJson.get((Object)"source_id"));
            }
            if (connectionJson.containsKey((Object)"sourceId") && connectionJson.get((Object)"sourceId") != null) {
                this.sourceId = String.valueOf(connectionJson.get((Object)"sourceId"));
            }
            if (connectionJson.containsKey((Object)"db_login") && connectionJson.get((Object)"db_login") != null) {
                this.userName = String.valueOf(connectionJson.get((Object)"db_login"));
            }
            if (connectionJson.containsKey((Object)"db_password") && connectionJson.get((Object)"db_password") != null) {
                this.password = String.valueOf(connectionJson.get((Object)"db_password"));
            }
            if (connectionJson.containsKey((Object)"username") && connectionJson.get((Object)"username") != null) {
                this.userName = String.valueOf(connectionJson.get((Object)"username"));
            }
            if (connectionJson.containsKey((Object)"password") && connectionJson.get((Object)"password") != null) {
                this.password = String.valueOf(connectionJson.get((Object)"password"));
            }
            if (connectionJson.containsKey((Object)"clientId") && connectionJson.get((Object)"clientId") != null) {
                this.clientId = connectionJson.get((Object)"clientId").toString();
            }
            if (connectionJson.containsKey((Object)"instance_name") && connectionJson.get((Object)"instance_name") != null) {
                this.instance_name = connectionJson.get((Object)"instance_name").toString();
            }
            if (connectionJson.containsKey((Object)"secretKey") && connectionJson.get((Object)"secretKey") != null) {
                this.secretKey = connectionJson.get((Object)"secretKey").toString();
            }
            if (connectionJson.containsKey((Object)"region") && connectionJson.get((Object)"region") != null) {
                this.region = connectionJson.get((Object)"region").toString();
            }
            if (connectionJson.containsKey((Object)"glueCrawler") && connectionJson.get((Object)"glueCrawler") != null) {
                this.glueCrawler = connectionJson.get((Object)"glueCrawler").toString();
            }
            if (connectionJson.containsKey((Object)"accessKey") && connectionJson.get((Object)"accessKey") != null) {
                this.accessKey = connectionJson.get((Object)"accessKey").toString();
            }
            if (connectionJson.containsKey((Object)"host") && connectionJson.get((Object)"host") != null) {
                this.host = String.valueOf(connectionJson.get((Object)"host"));
            }
            if (connectionJson.containsKey((Object)"url") && connectionJson.get((Object)"url") != null) {
                this.url = String.valueOf(connectionJson.get((Object)"url"));
            }
            if (connectionJson.containsKey((Object)"port") && connectionJson.get((Object)"port") != null) {
                String string = this.port = Util.isNullOrEmpty(this.port) ? connectionJson.get((Object)"port").toString() : this.port;
            }
            if (connectionJson.containsKey((Object)"database_sid") && connectionJson.get((Object)"database_sid") != null) {
                this.serviceId = String.valueOf(connectionJson.get((Object)"database_sid"));
            }
            if (connectionJson.containsKey((Object)"warehouse") && connectionJson.get((Object)"warehouse") != null) {
                this.warehouse = String.valueOf(connectionJson.get((Object)"warehouse"));
            }
            if (connectionJson.containsKey((Object)"schema_names") && connectionJson.get((Object)"schema_names") != null) {
                this.schemaName = String.valueOf(connectionJson.get((Object)"schema_names"));
            }
            if (connectionJson.containsKey((Object)"http_path") && connectionJson.get((Object)"http_path") != null) {
                this.httpPath = String.valueOf(connectionJson.get((Object)"http_path"));
            }
            if (connectionJson.containsKey((Object)"fileSystemPath") && connectionJson.get((Object)"fileSystemPath") != null) {
                this.fileSystemPath = CryptographicUtil.decrypt(connectionJson.get((Object)"fileSystemPath").toString());
                this.fileSystemPath = Util.isNullOrEmpty(this.fileSystemPath) ? connectionJson.get((Object)"fileSystemPath").toString() : this.fileSystemPath;
                this.fileSystemPath = this.fileSystemPath.replace("\\", "/");
            }
            if (connectionJson.containsKey((Object)"database") && connectionJson.get((Object)"database") != null) {
                this.database = connectionJson.get((Object)"database").toString();
            }
            if (connectionJson.containsKey((Object)"db_name") && connectionJson.get((Object)"db_name") != null) {
                this.database = connectionJson.get((Object)"db_name").toString();
            }
            if (connectionJson.containsKey((Object)"stagingBucket") && connectionJson.get((Object)"stagingBucket") != null) {
                this.stagingBucket = connectionJson.get((Object)"stagingBucket").toString();
            }
            if (connectionJson.containsKey((Object)"s3StagingBucketfolderPath") && connectionJson.get((Object)"s3StagingBucketfolderPath") != null) {
                this.s3StagingBucketfolderPath = connectionJson.get((Object)"s3StagingBucketfolderPath").toString();
            }
            if (connectionJson.containsKey((Object)"roleName") && connectionJson.get((Object)"roleName") != null) {
                this.roleName = connectionJson.get((Object)"roleName").toString();
            }
            if (connectionJson.containsKey((Object)"role_name") && connectionJson.get((Object)"role_name") != null) {
                this.roleName = connectionJson.get((Object)"role_name").toString();
            }
            if (connectionJson.containsKey((Object)"projectId") && connectionJson.get((Object)"projectId") != null) {
                this.projectId = connectionJson.get((Object)"projectId").toString();
            }
            if (connectionJson.containsKey((Object)"datasetId") && connectionJson.get((Object)"datasetId") != null) {
                this.datasetId = connectionJson.get((Object)"datasetId").toString();
            }
            if (connectionJson.containsKey((Object)"serviceAccountJWT") && connectionJson.get((Object)"serviceAccountJWT") != null) {
                this.biqQueryJWT = connectionJson.get((Object)"serviceAccountJWT").toString();
                byte[] valueDecoded = Base64.decodeBase64((String)this.biqQueryJWT);
                this.biqQueryJWT = new String(valueDecoded);
            }
            if (connectionJson.containsKey((Object)"test_connection_query") && connectionJson.get((Object)"test_connection_query") != null) {
                this.testConnectionQuery = connectionJson.get((Object)"test_connection_query").toString();
            }
            this.isTestConnection = (isTestCon = Boolean.valueOf(String.valueOf(dataSourceInfoAndQueryObject.get((Object)"is_test_connection")))) != null ? isTestCon : false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTestConnectionString() {
        return this.testConnectionQuery;
    }

    public void connect() throws Exception {
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        this.connection = DriverManager.getConnection(this.getURL(), this.userName, this.password);
    }

    public List<Map<String, Object>> performTestConnection(String query) throws Exception {
        ResultSet resultSet = this.connection.createStatement().executeQuery(query);
        return this.getHashMap(resultSet);
    }

    private List<Map<String, Object>> getHashMap(ResultSet rs_SubItemType) throws SQLException {
        ArrayList<Map<String, Object>> row = new ArrayList<Map<String, Object>>();
        ResultSetMetaData metaData = rs_SubItemType.getMetaData();
        int colCount = metaData.getColumnCount();
        while (rs_SubItemType.next()) {
            HashMap<String, Object> columns = new HashMap<String, Object>();
            int i = 1;
            while (i <= colCount) {
                columns.put(metaData.getColumnLabel(i), rs_SubItemType.getObject(i));
                ++i;
            }
            row.add(columns);
        }
        return row;
    }

    public ResultSet getResultSet(Connection connection, PreparedStatement preparedStatement) throws SQLException {
        return preparedStatement.executeQuery();
    }

    public void prepareStatment(String query, boolean createResultList, String dbType) throws SQLException {
        if ("SP".equalsIgnoreCase(this.sawsOperation)) {
            this.prepareCallableStatment(query);
        } else if ("BW".equalsIgnoreCase(this.sawsOperation)) {
            this.statement = this.connection.createStatement();
            this.connection.setAutoCommit(false);
        } else if ("PL".equalsIgnoreCase(this.sawsOperation)) {
            this.callableStatement = this.connection.prepareCall(query);
        } else {
            this.preparedStatement = !RefDBType.isExcel(dbType) && !RefDBType.isSnowflake(dbType) && createResultList ? this.connection.prepareStatement(query, 1004, 1007) : this.connection.prepareStatement(query);
        }
    }

    public void prepareCallableStatment(String queryString) throws SQLException {
        String procName = null;
        String params = null;
        String[] paramsArray = new String[]{};
        String query = !Util.isNullOrEmpty(queryString) ? queryString.replaceAll(",", "  ,") : "";
        if ((query = query.toLowerCase().replace("call ", "").replace("execute ", "")).contains("(") && query.contains(")")) {
            procName = query.trim().substring(0, query.indexOf("("));
            params = query.trim().substring(query.indexOf("(") + 1, query.indexOf(")"));
            paramsArray = params.trim().split(",");
        } else {
            procName = queryString;
        }
        this.inputPramasLength = paramsArray.length;
        StringBuilder procParam = new StringBuilder();
        int i = 0;
        while (i < paramsArray.length) {
            String paramPlaceHolder = i < paramsArray.length - 1 ? "?," : "?";
            procParam.append(paramPlaceHolder);
            ++i;
        }
        String proc = "{call " + procName + "(" + procParam.toString() + ") }";
        logger.debug(this.logFormat.getFormattedLog(), " Procedure executing ..... " + proc);
        this.callableStatement = this.connection.prepareCall(proc);
        this.setInputParams(paramsArray);
    }

    public void setInputParams(String[] paramsArray) throws SQLException {
        int i = 0;
        while (i < paramsArray.length) {
            String val = paramsArray[i].trim();
            String string = val = val != null ? val.trim().replaceAll("[\"'']", "") : null;
            if (Util.isNullOrEmpty(val) || val.equalsIgnoreCase("null")) {
                this.callableStatement.setString(i + 1, null);
            } else if (!val.contains(":x") && !val.contains(":X")) {
                if (NumberUtils.isDigits((String)val)) {
                    this.callableStatement.setInt(i + 1, Integer.parseInt(val));
                } else if (NumberUtils.isNumber((String)val)) {
                    this.callableStatement.setDouble(i + 1, Double.parseDouble(paramsArray[i].trim()));
                } else {
                    this.callableStatement.setString(i + 1, val.trim());
                }
            }
            ++i;
        }
    }

    public Object addOptionalProps(String optionalParamsStringified, Object connectionStrOrProps) {
        Object processedObj = connectionStrOrProps;
        if (Util.isNullOrEmpty(optionalParamsStringified) || connectionStrOrProps == null) {
            logger.info("Optional Params or Connection Str/Props are null or empty.");
            return processedObj;
        }
        try {
            JSONArray optionalParams = JsonUtil.parseToJsonArray(optionalParamsStringified);
            if (this.isConnectionString(connectionStrOrProps)) {
                String connStr = String.valueOf(connectionStrOrProps);
                StringBuilder connStrBuilder = new StringBuilder(connStr);
                boolean isFirst = !connStr.contains("?");
                for (Object optionalParamObj : optionalParams) {
                    JSONObject optionalParam = (JSONObject)optionalParamObj;
                    String key = String.valueOf(optionalParam.get((Object)"key"));
                    String value = String.valueOf(optionalParam.get((Object)"value"));
                    if (key == null || key.isEmpty() || value == null || value.isEmpty() || connStrBuilder.toString().contains(key)) continue;
                    connStrBuilder.append(isFirst ? "?" : "&");
                    connStrBuilder.append(key).append("=").append(value);
                    isFirst = false;
                }
                processedObj = connStrBuilder.toString();
            } else if (this.isProperties(connectionStrOrProps)) {
                Properties props = (Properties)connectionStrOrProps;
                for (Object optionalParamObj : optionalParams) {
                    JSONObject optionalParam = (JSONObject)optionalParamObj;
                    String key = String.valueOf(optionalParam.get((Object)"key"));
                    String value = String.valueOf(optionalParam.get((Object)"value"));
                    if (key == null || key.isEmpty() || value == null || value.isEmpty()) continue;
                    props.put(key, value);
                }
                processedObj = props;
            }
        }
        catch (Exception e) {
            logger.error("Error while processing optional properties. Error: ", e.getMessage());
            e.printStackTrace();
        }
        return processedObj;
    }

    private boolean isConnectionString(Object connectionStrOrProps) {
        return connectionStrOrProps instanceof String;
    }

    private boolean isProperties(Object connectionStrOrProps) {
        return connectionStrOrProps instanceof Properties;
    }

    public ResultSet executeSelectQuery(String query) throws SQLException {
        return this.preparedStatement.executeQuery();
    }

    public ResultSet executeProc(String query) throws SQLException {
        Boolean isResultset = this.callableStatement.execute();
        return isResultset != false ? this.callableStatement.getResultSet() : null;
    }

    public int executePLSQLBlock() throws SQLException {
        return this.callableStatement.executeUpdate();
    }

    public int getInputParamsLength() {
        return this.inputPramasLength;
    }

    public int executeWriteQuery() throws SQLException {
        return this.preparedStatement.executeUpdate();
    }

    public int[] executeBatch() throws SQLException, InterruptedException {
        int[] updateResults = null;
        try {
            updateResults = this.statement.executeBatch();
            this.connection.commit();
            return updateResults;
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getRootCauseMessage((Throwable)e);
            if (!msg.contains("ORA-00060")) {
                throw e;
            }
            Thread.sleep(2000L);
            this.executeBatch();
            return updateResults;
        }
    }

    public void rollBack() {
        logger.error(this.logFormat.getFormattedLog(), "Error: batch roll backed ....... ");
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            logger.error(this.logFormat.getFormattedLog(), e.getMessage());
        }
    }

    public void addBatchQuries(JSONArray queries) throws SQLException {
        int length = queries != null ? queries.size() : 0;
        StringBuilder batchQueries = new StringBuilder();
        int i = 0;
        while (i < length) {
            JSONObject queryObject = (JSONObject)queries.get(i);
            String query = String.valueOf(queryObject.get((Object)"WRQRY"));
            if (Util.isNotNullOrEmpty(query)) {
                this.statement.addBatch(query);
                batchQueries.append(String.valueOf(String.valueOf(queryObject.get((Object)"WRQRY"))) + " \\n");
            }
            ++i;
        }
    }

    public JSONObject executeQueryAndAppendResultTo(JSONObject dataSourceInfoAndQueryObject, boolean createResultList, ArrayList<String> resultList) {
        return dataSourceInfoAndQueryObject;
    }

    public JSONObject executeSAPWriteQuery(JSONObject tempDebug, boolean createResultList, ArrayList<String> resultList) {
        return tempDebug;
    }

    public void disconnect() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.callableStatement != null) {
                this.callableStatement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatusUtil.dcrementConnectionCount();
        System.gc();
        System.runFinalization();
    }

    public abstract String getDriver();

    public abstract String getURL();

    public ResultSet getTableCatalog() throws SQLException {
        return null;
    }

    public ResultSet getColumnCatalog() throws SQLException {
        return null;
    }

    public ResultSet getPrimaryKeyCatalog() throws SQLException {
        return null;
    }

    public ResultSet getForeignKeyCatalog() throws SQLException {
        return null;
    }

    public void cleanCDataCache() throws SQLException {
    }

    public ResultSet executeCatalog(String catalogType) throws SQLException {
        return null;
    }

    public ResultSet executeStatment(String query) throws SQLException {
        if ("SP".equalsIgnoreCase(this.sawsOperation)) {
            return this.executeProc(query);
        }
        return this.executeSelectQuery(query);
    }
}

