/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.controller;

import com.dvsum.controller.BaseController;
import com.dvsum.dto.FileInfo;
import com.dvsum.logger.CustomLogger;
import com.dvsum.services.FileUploadService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonPretifierUtil;
import com.dvsum.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
public class FileUploadController
extends BaseController {
    private static final long serialVersionUID = 1L;
    private static final CustomLogger logger = CustomLogger.getLogger(FileUploadController.class);
    @Autowired
    private FileUploadService fileUploadService;

    @CrossOrigin
    @RequestMapping(value={"/webservice/pre-process-json"}, method={RequestMethod.POST})
    @ResponseBody
    public String getPreProcessProperties(@RequestParam String folderPath, @RequestParam String fileName) {
        return !Util.isNullOrEmpty(folderPath) && !Util.isNullOrEmpty(fileName) ? FileUtil.readDataFromFile(String.valueOf(folderPath) + "/" + fileName) : null;
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/save-pre-process-json"}, method={RequestMethod.POST})
    @ResponseBody
    public String savePreProcessJson(@RequestParam String folderPath, @RequestParam String fileName, @RequestParam String preProcessJson) {
        return !Util.isNullOrEmpty(folderPath) && !Util.isNullOrEmpty(fileName) && !Util.isNullOrEmpty(preProcessJson) ? FileUtil.writeToFile(String.valueOf(folderPath) + "/" + fileName, JsonPretifierUtil.toPrettyFormat(preProcessJson)) : null;
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/uploadFile"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> upload(MultipartHttpServletRequest request, HttpServletResponse response, @RequestParam(required=false) String executeScript, @RequestParam(required=false) String updateProps) {
        String uploadedFiles = "";
        try {
            Map fileMap = request.getFileMap();
            executeScript = !Util.isNullOrEmpty(executeScript) ? executeScript : "true";
            updateProps = !Util.isNullOrEmpty(updateProps) ? updateProps : "true";
            for (MultipartFile multipartFile : fileMap.values()) {
                String templateFile;
                String fileName = multipartFile.getOriginalFilename();
                if (fileName.endsWith(".zip")) {
                    templateFile = request.getParameter("templateFilename");
                    System.out.println(" Dynamic template name : " + templateFile);
                    uploadedFiles = this.fileUploadService.unzip(request.getParameter("folder"), multipartFile, templateFile, executeScript, updateProps);
                    continue;
                }
                templateFile = request.getParameter("templateFilename");
                System.out.println(" Dynamic template name : " + templateFile);
                uploadedFiles = this.fileUploadService.upload(request.getParameter("folder"), multipartFile, templateFile, executeScript, updateProps);
            }
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.TEXT_PLAIN).body((Object)e.getMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).contentType(MediaType.TEXT_PLAIN).body((Object)uploadedFiles);
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/getAllFiles"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FileInfo> getFiles(@RequestParam(required=false) String directory) {
        ArrayList<FileInfo> resultList = new ArrayList<FileInfo>();
        List<FileInfo> files = this.fileUploadService.getAllFiles(directory, resultList);
        Collections.sort(files);
        return files != null && files.size() > 0 ? files : new ArrayList();
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/deleteFile"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteFile(@RequestParam String file) {
        this.fileUploadService.deleteFile(file);
    }

    @CrossOrigin
    @RequestMapping(value={"/webservice/downloadFile"}, method={RequestMethod.GET})
    public void downLoadFile(@RequestParam String filePath, HttpServletRequest request, HttpServletResponse response) {
        block8: {
            try {
                File file = new File(filePath);
                File tempFile = null;
                if (file.exists()) {
                    FileInputStream is = null;
                    String fileName = file.getName();
                    String preFix = fileName.replace(".xlsx", "");
                    JSONObject dynamicFiles = FileUtil.readFileAsJsonObject(String.valueOf(file.getParent()) + "/preservedExcel/dynamicFileTemplate.properties");
                    if (!dynamicFiles.isEmpty() && FileUtil.isExcel(fileName) && dynamicFiles.get((Object)file.getName().toUpperCase()) != null) {
                        System.out.println("executing python script ... ");
                        String tempFilePath = String.valueOf(file.getParent()) + "/" + preFix + "_temp.xlsx";
                        tempFile = new File(tempFilePath);
                        response.setContentLength(new Long(tempFile.length()).intValue());
                        response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
                        if (tempFile.exists()) {
                            logger.debug("downloading preserved file .... ");
                            is = new FileInputStream(tempFile);
                        } else {
                            logger.debug("downloading default file .... ");
                            response.setContentLength(new Long(file.length()).intValue());
                            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
                            is = new FileInputStream(file);
                        }
                    } else {
                        response.setContentLength(new Long(file.length()).intValue());
                        response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
                        is = new FileInputStream(file);
                    }
                    FileCopyUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.delete();
                    }
                    break block8;
                }
                throw new Exception("Error Downloading File");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Exception:", e);
            }
        }
    }
}

