/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.controller;

import com.dvsum.controller.BaseController;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.services.AnalyticsQueryExecutorService;
import com.dvsum.services.DataSourceConnectionService;
import com.dvsum.services.ExecutorServiceHandler;
import com.dvsum.services.RuleExecutionService;
import com.dvsum.services.SawsUpgradeService;
import com.dvsum.services.SourceService;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.StatusUtil;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DataSourceController
extends BaseController {
    private static final long serialVersionUID = 8663687681011569895L;
    private static final CustomLogger logger = CustomLogger.getLogger(DataSourceController.class);
    @Autowired
    private DataSourceConnectionService cdataTestConnectionService;
    @Autowired
    private SourceService sourceService;
    @Autowired
    private SawsUpgradeService sawsUpgradeService;
    @Autowired
    private AnalyticsQueryExecutorService analyticsQueryExecutorService;
    @Autowired
    private RuleExecutionService ruleExecutionService;
    @Autowired
    @Qualifier(value="managedThreadExecutor")
    private TaskExecutor managedThreadExecutor;

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/testConnection"}, method={RequestMethod.POST})
    public String testConnection(HttpServletRequest request, @RequestBody String connectionInfo) throws Exception {
        JSONObject connectionInfoJSON = JsonUtil.parseToJsonObject(connectionInfo);
        LogFormat logFormat = new LogFormat();
        logFormat.setLogFormat("scan", connectionInfoJSON);
        logger.info(logFormat.getFormattedLog(), "SAWS: Request received for Test Connection.");
        return this.sourceService.performTestConnection(connectionInfoJSON, logFormat);
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/runCmd"}, method={RequestMethod.POST})
    public void runCmd(@RequestBody String cmdString) throws Exception {
        logger.debug("runCmd invoked");
        SawsUpgradeService.executeCMD(cmdString);
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/getGBQDatasets"}, method={RequestMethod.POST})
    public JSONObject getGBQDatasets(@RequestBody String jwtString) throws Exception {
        logger.debug("getGBQDatasets invoked");
        return this.cdataTestConnectionService.getGBQDatasets(jwtString);
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/getVerifierCode"}, method={RequestMethod.POST})
    public JSONObject getVerifierCode(@RequestBody String data) throws Exception {
        logger.debug("getVerifierCode invoked");
        return this.cdataTestConnectionService.getVerifierCode(JsonUtil.parseToJsonObject(data));
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/authenticateVerifierCode"}, method={RequestMethod.POST})
    public ResponseEntity<JSONObject> authenticateVerifierCode(@RequestBody String data) throws Exception {
        logger.debug("authenticateVerifierCode invoked");
        JSONObject response = this.cdataTestConnectionService.authenticate(JsonUtil.parseToJsonObject(data));
        int status = "SUCCESS".equalsIgnoreCase(response.get((Object)"status").toString()) ? 200 : 401;
        return ResponseEntity.status((int)status).body((Object)response);
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/updateCdataLibs"}, method={RequestMethod.POST})
    public String updateCdataLibs(@RequestBody String key) throws Exception {
        String token = CryptographicUtil.decrypt(FileUtil.getAPIkey()).trim();
        if (token.equals(key = CryptographicUtil.decrypt(key).trim()) && StatusUtil.isSawsBusy()) {
            this.sawsUpgradeService.scheduleUpdateCDataLibs();
            return "SCHEDULE";
        }
        if (token.equals(key)) {
            return "DOWNLOAD";
        }
        if (!token.equals(key)) {
            return "INVALID_KEY";
        }
        return "FAILED";
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/downloadNewCdataLibs"}, method={RequestMethod.POST})
    public void downloadNewCdataLibs() throws Exception {
        this.sawsUpgradeService.downloadNewCdataLibs();
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/sources/{srcId}/databases"}, method={RequestMethod.POST})
    public ResponseEntity<JSONObject> getDatabases(@RequestBody String data, @PathVariable(value="srcId") Integer srcId) throws Exception {
        LogFormat logFormat = new LogFormat();
        logFormat.setLogFormat("scan", "", String.valueOf(srcId));
        logger.info(logFormat.getFormattedLog(), "Request received for getting databases.");
        JSONObject response = this.cdataTestConnectionService.getDatabases(data, srcId, logFormat);
        int statusCode = response.isEmpty() ? 401 : 200;
        return ResponseEntity.status((int)statusCode).body((Object)response);
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/sources/{srcId}/schemas"}, method={RequestMethod.POST})
    public ResponseEntity<JSONObject> getSchemas(@RequestBody String data, @PathVariable(value="srcId") Integer srcId) throws Exception {
        LogFormat logFormat = new LogFormat();
        logFormat.setLogFormat("scan", "", String.valueOf(srcId));
        logger.info(logFormat.getFormattedLog(), "Request received for getting schemas.");
        JSONObject response = this.cdataTestConnectionService.getSchemas(data, srcId, logFormat);
        int statusCode = response.isEmpty() ? 401 : 200;
        return ResponseEntity.status((int)statusCode).body((Object)response);
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/sources/{srcId}/authenticate"}, method={RequestMethod.POST})
    public ResponseEntity<String> authenticate(@RequestBody String data, @PathVariable(value="srcId") Integer srcId) {
        logger.info("/authenticate called for srcId {}", srcId);
        this.managedThreadExecutor.execute(() -> {
            try {
                LogFormat logFormat = new LogFormat();
                logFormat.setLogFormat("scan", "", String.valueOf(srcId));
                logger.info(logFormat.getFormattedLog(), "Request received for Authentication.");
                this.cdataTestConnectionService.getDatabases(data, srcId, logFormat);
                logger.info("/authenticate completed for srcId {}", srcId);
            }
            catch (Exception e) {
                logger.error("Error while Authentication. Error = {}", e.getMessage(), e);
            }
        });
        return ResponseEntity.ok((Object)"SUCCESS");
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/sources/{srcId}/execute"}, method={RequestMethod.POST})
    public ResponseEntity<String> executeQuery(@RequestBody String data, @PathVariable(value="srcId") Integer srcId) {
        logger.info("/execute called for srcId {}", srcId);
        this.managedThreadExecutor.execute(() -> {
            try {
                JSONObject analyticsQueriesMetaData = JsonUtil.parseToJsonObject(data);
                LogFormat logFormat = new LogFormat();
                logFormat.setLogFormat("chat", analyticsQueriesMetaData);
                this.analyticsQueryExecutorService.executeQueries(analyticsQueriesMetaData, logFormat);
                logger.info("/execute completed for srcId {}", srcId);
            }
            catch (Exception e) {
                logger.error("Error while executing query. Error = {}", e.getMessage(), e);
            }
        });
        return ResponseEntity.ok((Object)"SUCCESS");
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/jobs/{jobId}/execute"}, method={RequestMethod.POST})
    public ResponseEntity<String> executeJob(@RequestBody String data, @PathVariable(value="jobId") Integer jobId) throws Exception {
        logger.info("/execute called for jobId " + jobId);
        this.managedThreadExecutor.execute(() -> {
            try {
                JSONObject payload = JsonUtil.parseToJsonObject(data);
                JSONObject ruleExecutionMetadata = this.ruleExecutionService.getExecutionMetadataFromPayload(payload);
                this.ruleExecutionService.sendConnectionDetailsToWebsocket(ruleExecutionMetadata);
                this.ruleExecutionService.startExecution(ruleExecutionMetadata);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while job execution. Error = " + e.getMessage());
            }
        });
        return ResponseEntity.ok((Object)"SUCCESS");
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/jobs/{jobId}/cancel"}, method={RequestMethod.POST})
    public ResponseEntity<String> cancelJob(@RequestBody String data, @PathVariable(value="jobId") Integer jobId) {
        logger.info("/cancel execution called for jobId {}", jobId);
        this.managedThreadExecutor.execute(() -> {
            try {
                JSONObject payload = JsonUtil.parseToJsonObject(data);
                JSONObject cancelJobDetails = (JSONObject)payload.get((Object)"message");
                LogFormat logFormat = new LogFormat();
                logFormat.setLogFormat("rule", cancelJobDetails);
                String job_Id = (String)cancelJobDetails.get((Object)"job_id");
                logger.info(logFormat.getFormattedLog(), "Cancel scan request received for job: {}", job_Id);
                ExecutorServiceHandler.shutDownExecutorService(job_Id);
                logger.info(logFormat.getFormattedLog(), "Job {} cancelled successfully.", job_Id);
                logger.info("/cancel execution completed for jobId {}", jobId);
            }
            catch (Exception e) {
                logger.error("Error while job cancellation. Error = {}", e.getMessage(), e);
            }
        });
        return ResponseEntity.ok((Object)"SUCCESS");
    }
}

