/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.controller;

import com.dvsum.controller.BaseController;
import com.dvsum.logger.CustomLogger;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.QueryParam;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AnalyticsController
extends BaseController {
    private static final long serialVersionUID = 6040449534390095568L;
    private static final CustomLogger logger = CustomLogger.getLogger(AnalyticsController.class);

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/webservice/queries/results"}, method={RequestMethod.GET})
    public void downloadJson(HttpServletRequest request, HttpServletResponse response, @QueryParam(value="filePath") String filePath) {
        try {
            if (!this.validateApiKey(request)) {
                response.sendError(HttpStatus.FORBIDDEN.value(), "Invalid API key");
                return;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value(), "File not found");
                return;
            }
            logger.info("Reading data from file: " + filePath);
            String jsonData = FileUtil.readDataFromFile(filePath);
            String decryptedJsonData = CryptographicUtil.decrypt(jsonData);
            if (Util.isNullOrEmpty(decryptedJsonData)) {
                decryptedJsonData = jsonData;
            }
            response.setContentType("application/json");
            response.setHeader("Content-Encoding", "gzip");
            Throwable throwable = null;
            Object var8_10 = null;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());){
                gzipOutputStream.write(decryptedJsonData.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
    }

    @CrossOrigin
    @ResponseBody
    @RequestMapping(value={"/scan/sample-data"}, method={RequestMethod.GET})
    public void dowloadSampleData(HttpServletRequest request, HttpServletResponse response, @QueryParam(value="filePath") String filePath) {
        try {
            if (!this.validateApiKey(request)) {
                response.sendError(HttpStatus.FORBIDDEN.value(), "Invalid API key");
                return;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value(), "File not found");
                return;
            }
            logger.info("Reading sample data file: " + filePath);
            String fileContent = FileUtil.readDataFromFile(filePath);
            String sampelDataJson = CryptographicUtil.decrypt(fileContent);
            if (Util.isNullOrEmpty(sampelDataJson)) {
                sampelDataJson = fileContent;
            }
            response.setContentType("application/json");
            response.setHeader("Content-Encoding", "gzip");
            Throwable throwable = null;
            Object var8_10 = null;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)response.getOutputStream());){
                gzipOutputStream.write(sampelDataJson.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
    }

    private String readJsonFromFile(String filePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            StringBuilder jsonData = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonData.append(line);
            }
            return jsonData.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean validateApiKey(HttpServletRequest request) {
        String apiKey = request.getHeader("x-api-key");
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return false;
        }
        apiKey = AnalyticsController.decrypt(apiKey);
        String storedApiKey = FileUtil.getProperty("api.key");
        apiKey = apiKey.trim();
        return apiKey.equals(storedApiKey);
    }

    public static String decrypt(String input) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(input);
            String decodedString = new String(decodedBytes);
            return decodedString;
        }
        catch (IllegalArgumentException e) {
            return input;
        }
    }
}

