/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.config;

import com.dvsum.exception.CustomAsyncExceptionHandler;
import com.dvsum.filter.CORSIntercepter;
import com.dvsum.filter.UserSessionInterceptor;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"com.dvsum"})
@PropertySources(value={@PropertySource(value={"classpath:example-dev.properties"})})
@EnableWebMvc
@EnableAsync
@EnableScheduling
public class AppConfig
extends WebMvcConfigurerAdapter
implements AsyncConfigurer {
    private static final String[] propertyFiles = new String[]{"example-dev", "polling-urls", "application", "log4j-custom", "aws-s3"};
    @Autowired
    private CORSIntercepter corsIntercepter;
    @Autowired
    private UserSessionInterceptor sessionInterceptor;
    private int MAX_JOB_EXECUTOR;

    @Bean
    public static PropertyPlaceholderConfigurer properties() {
        PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
        ClassPathResource[] resources = new ClassPathResource[propertyFiles.length];
        int i = 0;
        while (i < propertyFiles.length) {
            resources[i] = new ClassPathResource(String.valueOf(propertyFiles[i]) + ".properties");
            ++i;
        }
        ppc.setLocations((Resource[])resources);
        ppc.setIgnoreUnresolvablePlaceholders(true);
        return ppc;
    }

    @Bean
    public ResourceBundleMessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(propertyFiles);
        return messageSource;
    }

    public void addResourceHandlers(ResourceHandlerRegistry aRegistry) {
        aRegistry.addResourceHandler(new String[]{"/c/**"}).addResourceLocations(new String[]{"classpath:/webapp/WEB-INF/view/css/"});
        aRegistry.addResourceHandler(new String[]{"/s/*"}).addResourceLocations(new String[]{"classpath:/webapp/WEB-INF/view/scripts/"});
        aRegistry.addResourceHandler(new String[]{"/i/**"}).addResourceLocations(new String[]{"classpath:/webapp/WEB-INF/view/images/"});
        aRegistry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/webapp/WEB-INF/view/images/favicon.ico"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.corsIntercepter).addPathPatterns(new String[]{"/**", "/webservice/uploadFile"});
        registry.addInterceptor((HandlerInterceptor)this.sessionInterceptor).addPathPatterns(new String[]{"/home", "/status", "/configuration", "/restart"});
    }

    @Bean
    public InternalResourceViewResolver viewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("WEB-INF/view/jsps/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver createMultipartResolver() {
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        return resolver;
    }

    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(20);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(200);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("AsyncExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Bean(name={"managedThreadExecutor"})
    public TaskExecutor managedThreadExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(20);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(200);
        executor.setThreadNamePrefix("GlobalAsync-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Bean(name={"jobExecutor"})
    public ThreadPoolTaskExecutor jobExecutor() {
        ThreadPoolTaskExecutor jobExecutor = new ThreadPoolTaskExecutor();
        jobExecutor.setCorePoolSize(10);
        jobExecutor.setMaxPoolSize(30);
        jobExecutor.setQueueCapacity(100);
        jobExecutor.setThreadNamePrefix("JobExecutor-");
        jobExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        jobExecutor.initialize();
        return jobExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new CustomAsyncExceptionHandler();
    }
}

