/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.cdatasource;

import com.dvsum.dataSource.CDataDataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.FileUtil;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.io.File;
import java.sql.DriverManager;
import java.util.Properties;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class SalesforceSource
extends CDataDataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING from account limit 1";

    public SalesforceSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public SalesforceSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "cdata.jdbc.salesforce.SalesforceDriver";
    }

    @Override
    public String getURL() {
        return "jdbc:salesforce:";
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            this.props.setProperty("InitiateOAuth", "REFRESH");
            this.props.setProperty("OAuthClientId", this.clientId);
            this.props.setProperty("OAuthClientSecret", this.secretKey);
            this.props.setProperty("OAuthSettingsLocation", this.getSettingsLocation(this.sourceId, this.authSettings));
            this.props.setProperty("ServerSideAggregation", "false");
            this.props.setProperty("Timeout", "0");
            this.props.setProperty("SessionTimeout", "0");
            if ("true".equalsIgnoreCase(this.useSandbox)) {
                this.props.setProperty("useSandbox", "true");
                this.props.setProperty("LoginURL", this.loginURL);
                this.props.setProperty("OAuthAccessTokenURL", this.getOauthTokenAccessURL(this.loginURL));
            }
            System.out.println("SALESFORCE : Build Connection");
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }

    private String getSettingsLocation(String sourceId, String authSettings) {
        String settingsLocation = "";
        try {
            String PARENT_DIR = String.valueOf(System.getProperty("user.dir")) + File.separator + "cdata" + File.separator;
            settingsLocation = String.valueOf(PARENT_DIR) + "auth-" + sourceId + ".txt";
            FileUtil.deleteFileIfExists(settingsLocation);
            FileUtil.writeToFile(settingsLocation, authSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settingsLocation;
    }

    private String getOauthTokenAccessURL(String loginURL) {
        if (loginURL.endsWith("/")) {
            return String.valueOf(loginURL) + "services/oauth2/token";
        }
        return String.valueOf(loginURL) + "/services/oauth2/token";
    }
}

