/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.cdatasource;

import com.dvsum.dataSource.CDataDataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.util.Properties;
import org.json.simple.JSONObject;

public class MongoDBSource
extends CDataDataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    private static final CustomLogger logger = CustomLogger.getLogger(MongoDBSource.class);

    public MongoDBSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public MongoDBSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "cdata.jdbc.mongodb.MongoDBDriver";
    }

    @Override
    public String getURL() {
        return "jdbc:mongodb:";
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            if (Util.isNotNullOrEmpty(this.host) && this.host.contains(".mongodb.net")) {
                logger.info(this.logFormat.getFormattedLog(), "Connecting to MongoDB Atlas");
                this.isOnCloud = true;
            }
            this.props.setProperty("Server", this.host);
            this.props.setProperty("Port", this.port);
            this.props.setProperty("User", this.userName);
            this.props.setProperty("Password", this.password);
            this.props.setProperty("AuthDatabase", Util.isNotNullOrEmpty(this.authDatabase) ? this.authDatabase : "admin");
            this.props.setProperty("AuthScheme", Util.isNotNullOrEmpty(this.authScheme) ? this.authScheme : "SCRAM-SHA-1");
            this.props.setProperty("UseSSL", "true".equalsIgnoreCase(this.useSSL) ? "true" : "false");
            if (Util.isNotNullOrEmpty(this.schemaName)) {
                this.props.setProperty("Database", this.schemaName);
            }
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }
}

