/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.cdatasource;

import com.dvsum.dataSource.CDataDataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.json.simple.JSONObject;

public class DatabricksSource
extends CDataDataSource {
    public static final String TEST_CONNECTION_QUERY = "select 1 as PING";
    private static final CustomLogger logger = CustomLogger.getLogger(DatabricksSource.class);

    public DatabricksSource(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
        this.isCataloging = isCataloging;
    }

    public DatabricksSource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "cdata.jdbc.databricks.DatabricksDriver";
    }

    @Override
    public String getURL() {
        return "jdbc:databricks:";
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            this.props.setProperty("Server", this.host);
            this.props.setProperty("HTTPPath", this.httpPath);
            this.props.setProperty("AuthScheme", this.authScheme);
            this.props.setProperty("QueryPassthrough", "true");
            this.props.setProperty("Other", "PersonalAccessTokenExpiresIn=43200;");
            this.props.setProperty("UseLegacyDataModel", "false");
            this.props.setProperty("CheckSQLWarehouseAvailability", "false");
            if (this.authScheme.equalsIgnoreCase("AzureServicePrincipal")) {
                this.props.setProperty("AzureTenantId", this.tenantId);
                this.props.setProperty("AzureClientId", this.clientId);
                this.props.setProperty("AzureClientSecret", this.clientSecret);
                this.props.setProperty("AzureSubscriptionId", this.subscriptionId);
                this.props.setProperty("AzureResourceGroup", this.resourceGroup);
                this.props.setProperty("AzureWorkspace", this.workspace);
            } else if (this.authScheme.equalsIgnoreCase("PersonalAccessToken")) {
                this.props.setProperty("Token", this.secretKey);
            }
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }

    @Override
    public ResultSet getTableCatalog() throws SQLException {
        if (Util.isNullOrEmpty(this.database)) {
            return this.connection.getMetaData().getTables(null, null, "%", null);
        }
        return this.connection.getMetaData().getTables(null, this.database, "%", null);
    }

    @Override
    public ResultSet getColumnCatalog() throws SQLException {
        if (Util.isNullOrEmpty(this.database)) {
            return this.connection.getMetaData().getColumns(null, null, "%", null);
        }
        return this.connection.getMetaData().getColumns(null, this.database, "%", null);
    }

    @Override
    public ResultSet getPrimaryKeyCatalog() throws SQLException {
        if (Util.isNullOrEmpty(this.database)) {
            return this.connection.getMetaData().getPrimaryKeys(null, null, "%");
        }
        return this.connection.getMetaData().getPrimaryKeys(null, this.database, "%");
    }

    @Override
    public ResultSet getForeignKeyCatalog() throws SQLException {
        if (Util.isNullOrEmpty(this.database)) {
            return this.connection.getMetaData().getImportedKeys(null, null, "%");
        }
        return this.connection.getMetaData().getImportedKeys(null, this.database, "%");
    }
}

