/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.cdatasource;

import com.dvsum.dataSource.CDataDataSource;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.util.Properties;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class BigQuerySource
extends CDataDataSource {
    public static final String TEST_CONNECTION_QUERY = "SELECT 1 as PING FROM PROJECTS LIMIT 1";

    public BigQuerySource(JSONObject DBInfo, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.testConnectionQuery = TEST_CONNECTION_QUERY;
    }

    public BigQuerySource() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "";
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        Properties props = new Properties();
        props.setProperty("ProjectId", this.projectId);
        if (Util.isNotNullOrEmpty(this.datasetId)) {
            props.setProperty("DatasetId", this.datasetId);
        }
        props.setProperty("AuthScheme", "OAuthJWT");
        props.setProperty("InitiateOAuth", "GETANDREFRESH");
        props.setProperty("OAuthJWTCertType", "GOOGLEJSONBLOB");
        props.setProperty("ShowTableDescriptions", "true");
        props.setProperty("OAuthJWTCert", this.biqQueryJWT);
        props.setProperty("Other", "ConnectOnOpen=True;UnnestArrays=Data;");
        this.connection = DriverManager.getConnection(this.getURL(), props);
    }
}

