/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.cdatasource;

import com.dvsum.dataSource.CDataDataSource;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.FileUtil;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class AmazonS3Source
extends CDataDataSource {
    private static final CustomLogger logger = CustomLogger.getLogger(AmazonS3Source.class);
    private Map<String, String> regions = new HashMap<String, String>();

    public AmazonS3Source(JSONObject DBInfo, boolean isCataloging, LogFormat logFormat) {
        super(logFormat);
        this.initializeConnectionParameters(DBInfo);
        this.isCataloging = isCataloging;
    }

    public AmazonS3Source() {
        super(new LogFormat());
    }

    @Override
    public String getDriver() {
        return "cdata.jdbc.amazonathena.AmazonAthenaDriver";
    }

    @Override
    public String getURL() {
        return "jdbc:amazonathena:";
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        StatusUtil.incerementConnectionCount();
        Class.forName(this.getDriver());
        if (Util.isNullOrEmpty(this.connectionString)) {
            String queryTimeout = FileUtil.getPropertyWithDefault("athena.query.timeout.seconds", "600");
            this.populateRegionsMap();
            this.props.setProperty("AWSAccessKey", this.accessKey);
            this.props.setProperty("AWSSecretKey", this.secretKey);
            this.props.setProperty("Database", this.database);
            this.props.setProperty("AWSRegion", this.regions.get(this.region));
            this.props.setProperty("S3StagingDirectory", "s3://" + this.stagingBucket + "/" + this.s3StagingBucketfolderPath);
            logger.info("Creating S3 connection - is Cataloging: " + this.isCataloging);
            if (this.isCataloging) {
                logger.info("Creating S3 connection - discovery by athena");
                this.props.setProperty("MetadataDiscoveryMethod", "Athena");
            } else {
                logger.info("Creating S3 connection - discovery by glue");
                this.props.setProperty("MetadataDiscoveryMethod", "Glue");
            }
            this.props.setProperty("QueryCachingLevel", "None");
            this.props.setProperty("QueryPassthrough", "true");
            this.props.setProperty("QueryTimeout", queryTimeout);
            this.props.setProperty("Verbosity", "1");
            this.props.setProperty("other", "schema=;MaskSensitiveConnectionProperties=false;");
            this.props = (Properties)this.addOptionalProps(this.optionalParams, this.props);
            this.connection = DriverManager.getConnection(this.getURL(), this.props);
        } else {
            this.connection = DriverManager.getConnection(this.connectionString, this.props);
        }
    }

    public void populateRegionsMap() {
        this.regions.put("us-east-2", "OHIO");
        this.regions.put("us-east-1", "NORTHERNVIRGINIA");
        this.regions.put("us-west-1", "NORTHERNCALIFORNIA");
        this.regions.put("us-west-2", "OREGON");
        this.regions.put("af-south-1", "CAPETOWN");
        this.regions.put("ap-east-1", "HONGKONG");
        this.regions.put("ap-southeast-3", "JAKARTA");
        this.regions.put("ap-south-1", "MUMBAI");
        this.regions.put("ap-northeast-3", "OSAKA");
        this.regions.put("ap-northeast-2", "SEOUL");
        this.regions.put("ap-southeast-1", "SINGAPORE");
        this.regions.put("ap-southeast-2", "SYDNEY");
        this.regions.put("ap-northeast-1", "TOKYO");
        this.regions.put("ca-central-1", "CENTRAL");
        this.regions.put("eu-central-1", "FRANKFURT");
        this.regions.put("eu-west-1", "IRELAND");
        this.regions.put("eu-west-2", "LONDON");
        this.regions.put("eu-south-1", "MILAN");
        this.regions.put("eu-west-3", "PARIS");
        this.regions.put("us-north-1", "STOCKHOLM");
        this.regions.put("me-south-1", "BAHRAIN");
        this.regions.put("sa-east-1", "SAOPAULO");
        this.regions.put("us-gov-east-1", "GOVCLOUDEAST");
        this.regions.put("us-gov-west-1", "GOVCLOUDWEST");
    }
}

